import 'package:viserpay/core/utils/method.dart';
import 'package:viserpay/core/utils/url_container.dart';
import 'package:viserpay/data/model/global/response_model/response_model.dart';
import 'package:viserpay/data/services/api_service.dart';

class RewardRepo {
  ApiClient apiClient;
  RewardRepo({required this.apiClient});

  Future<ResponseModel> getRewardHistory() async {
    return await apiClient.request(UrlContainer.rewardData, Method.getMethod, {}, passHeader: true);
  }

  Future<ResponseModel> redeemReward(String id) async {
    return await apiClient.request(UrlContainer.rewardRedeem, Method.postMethod, {'reward_id': id}, passHeader: true);
  }
}
